/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.filters;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.FlushableGZIPOutputStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.compat.JreCompat;

public class GzipOutputFilter
implements OutputFilter {
    protected static Log log = LogFactory.getLog(GzipOutputFilter.class);
    protected OutputBuffer buffer;
    protected GZIPOutputStream compressionStream = null;
    protected OutputStream fakeOutputStream = new FakeOutputStream();

    @Override
    public int doWrite(ByteChunk byteChunk, Response response) throws IOException {
        if (this.compressionStream == null) {
            this.compressionStream = JreCompat.isJre7Available() ? JreCompat.getInstance().getFlushableGZipOutputStream(this.fakeOutputStream) : new FlushableGZIPOutputStream(this.fakeOutputStream);
        }
        this.compressionStream.write(byteChunk.getBytes(), byteChunk.getStart(), byteChunk.getLength());
        return byteChunk.getLength();
    }

    @Override
    public long getBytesWritten() {
        return this.buffer.getBytesWritten();
    }

    public void flush() {
        block4: {
            if (this.compressionStream != null) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Flushing the compression stream!");
                    }
                    this.compressionStream.flush();
                }
                catch (IOException iOException) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)"Ignored exception while flushing gzip filter", (Throwable)iOException);
                }
            }
        }
    }

    @Override
    public void setResponse(Response response) {
    }

    @Override
    public void setBuffer(OutputBuffer outputBuffer) {
        this.buffer = outputBuffer;
    }

    @Override
    public long end() throws IOException {
        if (this.compressionStream == null) {
            this.compressionStream = JreCompat.isJre7Available() ? JreCompat.getInstance().getFlushableGZipOutputStream(this.fakeOutputStream) : new FlushableGZIPOutputStream(this.fakeOutputStream);
        }
        this.compressionStream.finish();
        this.compressionStream.close();
        return ((OutputFilter)this.buffer).end();
    }

    @Override
    public void recycle() {
        this.compressionStream = null;
    }

    protected class FakeOutputStream
    extends OutputStream {
        protected ByteChunk outputChunk = new ByteChunk();
        protected byte[] singleByteBuffer = new byte[1];

        protected FakeOutputStream() {
        }

        @Override
        public void write(int n) throws IOException {
            this.singleByteBuffer[0] = (byte)(n & 0xFF);
            this.outputChunk.setBytes(this.singleByteBuffer, 0, 1);
            GzipOutputFilter.this.buffer.doWrite(this.outputChunk, null);
        }

        @Override
        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.outputChunk.setBytes(byArray, n, n2);
            GzipOutputFilter.this.buffer.doWrite(this.outputChunk, null);
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

