/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileChannel;
import java.nio.channels.NetworkChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLEngine;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.collections.SynchronizedQueue;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AbstractJsseEndpoint;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioSelectorPool;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SecureNioChannel;
import org.apache.tomcat.util.net.SendfileDataBase;
import org.apache.tomcat.util.net.SendfileState;
import org.apache.tomcat.util.net.SocketBufferHandler;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketProcessorBase;
import org.apache.tomcat.util.net.SocketProperties;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.net.jsse.JSSESupport;

public class NioEndpoint
extends AbstractJsseEndpoint<NioChannel> {
    private static final Log log = LogFactory.getLog(NioEndpoint.class);
    public static final int OP_REGISTER = 256;
    private NioSelectorPool selectorPool = new NioSelectorPool();
    private volatile ServerSocketChannel serverSock = null;
    private volatile CountDownLatch stopLatch = null;
    private SynchronizedStack<PollerEvent> eventCache;
    private SynchronizedStack<NioChannel> nioChannels;
    private boolean useInheritedChannel = false;
    private int pollerThreadPriority = 5;
    private int pollerThreadCount = Math.min(2, Runtime.getRuntime().availableProcessors());
    private long selectorTimeout = 1000L;
    private Poller[] pollers = null;
    private AtomicInteger pollerRotater = new AtomicInteger(0);

    @Override
    public boolean setProperty(String string, String string2) {
        try {
            if (string.startsWith("selectorPool.")) {
                return IntrospectionUtils.setProperty((Object)this.selectorPool, (String)string.substring("selectorPool.".length()), (String)string2);
            }
            return super.setProperty(string, string2);
        }
        catch (Exception exception) {
            log.error((Object)("Unable to set attribute \"" + string + "\" to \"" + string2 + "\""), (Throwable)exception);
            return false;
        }
    }

    public void setUseInheritedChannel(boolean bl) {
        this.useInheritedChannel = bl;
    }

    public boolean getUseInheritedChannel() {
        return this.useInheritedChannel;
    }

    public void setPollerThreadPriority(int n) {
        this.pollerThreadPriority = n;
    }

    public int getPollerThreadPriority() {
        return this.pollerThreadPriority;
    }

    public void setPollerThreadCount(int n) {
        this.pollerThreadCount = n;
    }

    public int getPollerThreadCount() {
        return this.pollerThreadCount;
    }

    public void setSelectorTimeout(long l) {
        this.selectorTimeout = l;
    }

    public long getSelectorTimeout() {
        return this.selectorTimeout;
    }

    public Poller getPoller0() {
        int n = Math.abs(this.pollerRotater.incrementAndGet()) % this.pollers.length;
        return this.pollers[n];
    }

    public void setSelectorPool(NioSelectorPool nioSelectorPool) {
        this.selectorPool = nioSelectorPool;
    }

    public void setSocketProperties(SocketProperties socketProperties) {
        this.socketProperties = socketProperties;
    }

    @Override
    public boolean getDeferAccept() {
        return false;
    }

    public int getKeepAliveCount() {
        if (this.pollers == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.pollers.length; ++i) {
            n += this.pollers[i].getKeyCount();
        }
        return n;
    }

    @Override
    public void bind() throws Exception {
        if (!this.getUseInheritedChannel()) {
            this.serverSock = ServerSocketChannel.open();
            this.socketProperties.setProperties(this.serverSock.socket());
            InetSocketAddress inetSocketAddress = this.getAddress() != null ? new InetSocketAddress(this.getAddress(), this.getPort()) : new InetSocketAddress(this.getPort());
            this.serverSock.socket().bind(inetSocketAddress, this.getAcceptCount());
        } else {
            Channel channel = System.inheritedChannel();
            if (channel instanceof ServerSocketChannel) {
                this.serverSock = (ServerSocketChannel)channel;
            }
            if (this.serverSock == null) {
                throw new IllegalArgumentException(sm.getString("endpoint.init.bind.inherited"));
            }
        }
        this.serverSock.configureBlocking(true);
        if (this.acceptorThreadCount == 0) {
            this.acceptorThreadCount = 1;
        }
        if (this.pollerThreadCount <= 0) {
            this.pollerThreadCount = 1;
        }
        this.setStopLatch(new CountDownLatch(this.pollerThreadCount));
        this.initialiseSsl();
        this.selectorPool.open();
    }

    @Override
    public void startInternal() throws Exception {
        if (!this.running) {
            this.running = true;
            this.paused = false;
            this.processorCache = new SynchronizedStack(128, this.socketProperties.getProcessorCache());
            this.eventCache = new SynchronizedStack(128, this.socketProperties.getEventCache());
            this.nioChannels = new SynchronizedStack(128, this.socketProperties.getBufferPool());
            if (this.getExecutor() == null) {
                this.createExecutor();
            }
            this.initializeConnectionLatch();
            this.pollers = new Poller[this.getPollerThreadCount()];
            for (int i = 0; i < this.pollers.length; ++i) {
                this.pollers[i] = new Poller();
                Thread thread = new Thread((Runnable)this.pollers[i], this.getName() + "-ClientPoller-" + i);
                thread.setPriority(this.threadPriority);
                thread.setDaemon(true);
                thread.start();
            }
            this.startAcceptorThreads();
        }
    }

    @Override
    public void stopInternal() {
        this.releaseConnectionLatch();
        if (!this.paused) {
            this.pause();
        }
        if (this.running) {
            this.running = false;
            this.unlockAccept();
            for (int i = 0; this.pollers != null && i < this.pollers.length; ++i) {
                if (this.pollers[i] == null) continue;
                this.pollers[i].destroy();
                this.pollers[i] = null;
            }
            try {
                if (!this.getStopLatch().await(this.selectorTimeout + 100L, TimeUnit.MILLISECONDS)) {
                    log.warn((Object)sm.getString("endpoint.nio.stopLatchAwaitFail"));
                }
            }
            catch (InterruptedException interruptedException) {
                log.warn((Object)sm.getString("endpoint.nio.stopLatchAwaitInterrupted"), (Throwable)interruptedException);
            }
            this.shutdownExecutor();
            this.eventCache.clear();
            this.nioChannels.clear();
            this.processorCache.clear();
        }
    }

    @Override
    public void unbind() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroy initiated for " + new InetSocketAddress(this.getAddress(), this.getPort())));
        }
        if (this.running) {
            this.stop();
        }
        try {
            this.doCloseServerSocket();
        }
        catch (IOException iOException) {
            this.getLog().warn((Object)sm.getString("endpoint.serverSocket.closeFailed", new Object[]{this.getName()}), (Throwable)iOException);
        }
        this.destroySsl();
        super.unbind();
        if (this.getHandler() != null) {
            this.getHandler().recycle();
        }
        this.selectorPool.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroy completed for " + new InetSocketAddress(this.getAddress(), this.getPort())));
        }
    }

    @Override
    protected void doCloseServerSocket() throws IOException {
        if (!this.getUseInheritedChannel() && this.serverSock != null) {
            this.serverSock.socket().close();
            this.serverSock.close();
        }
        this.serverSock = null;
    }

    public int getWriteBufSize() {
        return this.socketProperties.getTxBufSize();
    }

    public int getReadBufSize() {
        return this.socketProperties.getRxBufSize();
    }

    public NioSelectorPool getSelectorPool() {
        return this.selectorPool;
    }

    @Override
    protected AbstractEndpoint.Acceptor createAcceptor() {
        return new Acceptor();
    }

    protected CountDownLatch getStopLatch() {
        return this.stopLatch;
    }

    protected void setStopLatch(CountDownLatch countDownLatch) {
        this.stopLatch = countDownLatch;
    }

    protected boolean setSocketOptions(SocketChannel socketChannel) {
        try {
            socketChannel.configureBlocking(false);
            Socket socket = socketChannel.socket();
            this.socketProperties.setProperties(socket);
            NioChannel nioChannel = (NioChannel)this.nioChannels.pop();
            if (nioChannel == null) {
                SocketBufferHandler socketBufferHandler = new SocketBufferHandler(this.socketProperties.getAppReadBufSize(), this.socketProperties.getAppWriteBufSize(), this.socketProperties.getDirectBuffer());
                nioChannel = this.isSSLEnabled() ? new SecureNioChannel(socketChannel, socketBufferHandler, this.selectorPool, this) : new NioChannel(socketChannel, socketBufferHandler);
            } else {
                nioChannel.setIOChannel(socketChannel);
                nioChannel.reset();
            }
            this.getPoller0().register(nioChannel);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            try {
                log.error((Object)"", throwable);
            }
            catch (Throwable throwable2) {
                ExceptionUtils.handleThrowable((Throwable)throwable2);
            }
            return false;
        }
        return true;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected NetworkChannel getServerSocket() {
        return this.serverSock;
    }

    @Override
    protected SocketProcessorBase<NioChannel> createSocketProcessor(SocketWrapperBase<NioChannel> socketWrapperBase, SocketEvent socketEvent) {
        return new SocketProcessor(socketWrapperBase, socketEvent);
    }

    private void close(NioChannel nioChannel, SelectionKey selectionKey) {
        try {
            if (nioChannel.getPoller().cancelledKey(selectionKey) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Socket: [" + nioChannel + "] closed"));
                }
                if (this.running && !this.paused && !this.nioChannels.push((Object)nioChannel)) {
                    nioChannel.free();
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)"", (Throwable)exception);
        }
    }

    public static class SendfileData
    extends SendfileDataBase {
        protected volatile FileChannel fchannel;

        public SendfileData(String string, long l, long l2) {
            super(string, l, l2);
        }
    }

    protected class SocketProcessor
    extends SocketProcessorBase<NioChannel> {
        public SocketProcessor(SocketWrapperBase<NioChannel> socketWrapperBase, SocketEvent socketEvent) {
            super(socketWrapperBase, socketEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doRun() {
            NioChannel nioChannel = (NioChannel)this.socketWrapper.getSocket();
            SelectionKey selectionKey = nioChannel.getIOChannel().keyFor(nioChannel.getPoller().getSelector());
            try {
                int n = -1;
                try {
                    if (selectionKey != null) {
                        if (nioChannel.isHandshakeComplete()) {
                            n = 0;
                        } else if (this.event == SocketEvent.STOP || this.event == SocketEvent.DISCONNECT || this.event == SocketEvent.ERROR) {
                            n = -1;
                        } else {
                            n = nioChannel.handshake(selectionKey.isReadable(), selectionKey.isWritable());
                            this.event = SocketEvent.OPEN_READ;
                        }
                    }
                }
                catch (IOException iOException) {
                    n = -1;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Error during SSL handshake", (Throwable)iOException);
                    }
                }
                catch (CancelledKeyException cancelledKeyException) {
                    n = -1;
                }
                if (n == 0) {
                    AbstractEndpoint.Handler.SocketState socketState = AbstractEndpoint.Handler.SocketState.OPEN;
                    socketState = this.event == null ? NioEndpoint.this.getHandler().process(this.socketWrapper, SocketEvent.OPEN_READ) : NioEndpoint.this.getHandler().process(this.socketWrapper, this.event);
                    if (socketState == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        NioEndpoint.this.close(nioChannel, selectionKey);
                    }
                } else if (n == -1) {
                    NioEndpoint.this.getHandler().process(this.socketWrapper, SocketEvent.CONNECT_FAIL);
                    NioEndpoint.this.close(nioChannel, selectionKey);
                } else if (n == 1) {
                    this.socketWrapper.registerReadInterest();
                } else if (n == 4) {
                    this.socketWrapper.registerWriteInterest();
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                nioChannel.getPoller().cancelledKey(selectionKey);
            }
            catch (VirtualMachineError virtualMachineError) {
                ExceptionUtils.handleThrowable((Throwable)virtualMachineError);
            }
            catch (Throwable throwable) {
                log.error((Object)"", throwable);
                nioChannel.getPoller().cancelledKey(selectionKey);
            }
            finally {
                this.socketWrapper = null;
                this.event = null;
                if (NioEndpoint.this.running && !NioEndpoint.this.paused) {
                    NioEndpoint.this.processorCache.push((Object)this);
                }
            }
        }
    }

    public static class NioSocketWrapper
    extends SocketWrapperBase<NioChannel> {
        private final NioSelectorPool pool;
        private Poller poller = null;
        private int interestOps = 0;
        private CountDownLatch readLatch = null;
        private CountDownLatch writeLatch = null;
        private volatile SendfileData sendfileData = null;
        private volatile long lastRead;
        private volatile long lastWrite = this.lastRead = System.currentTimeMillis();
        private volatile boolean closed = false;

        public NioSocketWrapper(NioChannel nioChannel, NioEndpoint nioEndpoint) {
            super(nioChannel, nioEndpoint);
            this.pool = nioEndpoint.getSelectorPool();
            this.socketBufferHandler = nioChannel.getBufHandler();
        }

        public Poller getPoller() {
            return this.poller;
        }

        public void setPoller(Poller poller) {
            this.poller = poller;
        }

        public int interestOps() {
            return this.interestOps;
        }

        public int interestOps(int n) {
            this.interestOps = n;
            return n;
        }

        public CountDownLatch getReadLatch() {
            return this.readLatch;
        }

        public CountDownLatch getWriteLatch() {
            return this.writeLatch;
        }

        protected CountDownLatch resetLatch(CountDownLatch countDownLatch) {
            if (countDownLatch == null || countDownLatch.getCount() == 0L) {
                return null;
            }
            throw new IllegalStateException("Latch must be at count 0");
        }

        public void resetReadLatch() {
            this.readLatch = this.resetLatch(this.readLatch);
        }

        public void resetWriteLatch() {
            this.writeLatch = this.resetLatch(this.writeLatch);
        }

        protected CountDownLatch startLatch(CountDownLatch countDownLatch, int n) {
            if (countDownLatch == null || countDownLatch.getCount() == 0L) {
                return new CountDownLatch(n);
            }
            throw new IllegalStateException("Latch must be at count 0 or null.");
        }

        public void startReadLatch(int n) {
            this.readLatch = this.startLatch(this.readLatch, n);
        }

        public void startWriteLatch(int n) {
            this.writeLatch = this.startLatch(this.writeLatch, n);
        }

        protected void awaitLatch(CountDownLatch countDownLatch, long l, TimeUnit timeUnit) throws InterruptedException {
            if (countDownLatch == null) {
                throw new IllegalStateException("Latch cannot be null");
            }
            countDownLatch.await(l, timeUnit);
        }

        public void awaitReadLatch(long l, TimeUnit timeUnit) throws InterruptedException {
            this.awaitLatch(this.readLatch, l, timeUnit);
        }

        public void awaitWriteLatch(long l, TimeUnit timeUnit) throws InterruptedException {
            this.awaitLatch(this.writeLatch, l, timeUnit);
        }

        public void setSendfileData(SendfileData sendfileData) {
            this.sendfileData = sendfileData;
        }

        public SendfileData getSendfileData() {
            return this.sendfileData;
        }

        public void updateLastWrite() {
            this.lastWrite = System.currentTimeMillis();
        }

        public long getLastWrite() {
            return this.lastWrite;
        }

        public void updateLastRead() {
            this.lastRead = System.currentTimeMillis();
        }

        public long getLastRead() {
            return this.lastRead;
        }

        @Override
        public boolean isReadyForRead() throws IOException {
            this.socketBufferHandler.configureReadBufferForRead();
            if (this.socketBufferHandler.getReadBuffer().remaining() > 0) {
                return true;
            }
            this.fillReadBuffer(false);
            boolean bl = this.socketBufferHandler.getReadBuffer().position() > 0;
            return bl;
        }

        @Override
        public int read(boolean bl, byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.populateReadBuffer(byArray, n, n2);
            if (n3 > 0) {
                return n3;
            }
            n3 = this.fillReadBuffer(bl);
            this.updateLastRead();
            if (n3 > 0) {
                this.socketBufferHandler.configureReadBufferForRead();
                n3 = Math.min(n3, n2);
                this.socketBufferHandler.getReadBuffer().get(byArray, n, n3);
            }
            return n3;
        }

        @Override
        public int read(boolean bl, ByteBuffer byteBuffer) throws IOException {
            int n = this.populateReadBuffer(byteBuffer);
            if (n > 0) {
                return n;
            }
            int n2 = this.socketBufferHandler.getReadBuffer().capacity();
            if (byteBuffer.remaining() >= n2) {
                byteBuffer.limit(byteBuffer.position() + n2);
                n = this.fillReadBuffer(bl, byteBuffer);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Socket: [" + this + "], Read direct from socket: [" + n + "]"));
                }
                this.updateLastRead();
            } else {
                n = this.fillReadBuffer(bl);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Socket: [" + this + "], Read into buffer: [" + n + "]"));
                }
                this.updateLastRead();
                if (n > 0) {
                    n = this.populateReadBuffer(byteBuffer);
                }
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            ((NioChannel)this.getSocket()).close();
            this.getEndpoint().getHandler().release(this);
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        private int fillReadBuffer(boolean bl) throws IOException {
            this.socketBufferHandler.configureReadBufferForWrite();
            return this.fillReadBuffer(bl, this.socketBufferHandler.getReadBuffer());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int fillReadBuffer(boolean bl, ByteBuffer byteBuffer) throws IOException {
            int n;
            NioChannel nioChannel = (NioChannel)this.getSocket();
            if (bl) {
                Selector selector = null;
                try {
                    selector = this.pool.get();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    NioSocketWrapper nioSocketWrapper = (NioSocketWrapper)nioChannel.getAttachment();
                    if (nioSocketWrapper == null) {
                        throw new IOException("Key must be cancelled.");
                    }
                    n = this.pool.read(byteBuffer, nioChannel, selector, nioSocketWrapper.getReadTimeout());
                }
                finally {
                    if (selector != null) {
                        this.pool.put(selector);
                    }
                }
            }
            n = nioChannel.read(byteBuffer);
            if (n == -1) {
                throw new EOFException();
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWrite(boolean bl, ByteBuffer byteBuffer) throws IOException {
            long l = this.getWriteTimeout();
            Selector selector = null;
            try {
                selector = this.pool.get();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.pool.write(byteBuffer, (NioChannel)this.getSocket(), selector, l, bl);
                if (bl) {
                    while (!((NioChannel)this.getSocket()).flush(true, selector, l)) {
                    }
                }
                this.updateLastWrite();
            }
            finally {
                if (selector != null) {
                    this.pool.put(selector);
                }
            }
        }

        @Override
        public void registerReadInterest() {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("endpoint.debug.registerRead", new Object[]{this}));
            }
            this.getPoller().add((NioChannel)this.getSocket(), 1);
        }

        @Override
        public void registerWriteInterest() {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("endpoint.debug.registerWrite", new Object[]{this}));
            }
            this.getPoller().add((NioChannel)this.getSocket(), 4);
        }

        @Override
        public SendfileDataBase createSendfileData(String string, long l, long l2) {
            return new SendfileData(string, l, l2);
        }

        @Override
        public SendfileState processSendfile(SendfileDataBase sendfileDataBase) {
            this.setSendfileData((SendfileData)sendfileDataBase);
            SelectionKey selectionKey = ((NioChannel)this.getSocket()).getIOChannel().keyFor(((NioChannel)this.getSocket()).getPoller().getSelector());
            return ((NioChannel)this.getSocket()).getPoller().processSendfile(selectionKey, this, true);
        }

        @Override
        protected void populateRemoteAddr() {
            InetAddress inetAddress = ((NioChannel)this.getSocket()).getIOChannel().socket().getInetAddress();
            if (inetAddress != null) {
                this.remoteAddr = inetAddress.getHostAddress();
            }
        }

        @Override
        protected void populateRemoteHost() {
            InetAddress inetAddress = ((NioChannel)this.getSocket()).getIOChannel().socket().getInetAddress();
            if (inetAddress != null) {
                this.remoteHost = inetAddress.getHostName();
                if (this.remoteAddr == null) {
                    this.remoteAddr = inetAddress.getHostAddress();
                }
            }
        }

        @Override
        protected void populateRemotePort() {
            this.remotePort = ((NioChannel)this.getSocket()).getIOChannel().socket().getPort();
        }

        @Override
        protected void populateLocalName() {
            InetAddress inetAddress = ((NioChannel)this.getSocket()).getIOChannel().socket().getLocalAddress();
            if (inetAddress != null) {
                this.localName = inetAddress.getHostName();
            }
        }

        @Override
        protected void populateLocalAddr() {
            InetAddress inetAddress = ((NioChannel)this.getSocket()).getIOChannel().socket().getLocalAddress();
            if (inetAddress != null) {
                this.localAddr = inetAddress.getHostAddress();
            }
        }

        @Override
        protected void populateLocalPort() {
            this.localPort = ((NioChannel)this.getSocket()).getIOChannel().socket().getLocalPort();
        }

        @Override
        public SSLSupport getSslSupport(String string) {
            if (this.getSocket() instanceof SecureNioChannel) {
                SecureNioChannel secureNioChannel = (SecureNioChannel)this.getSocket();
                return secureNioChannel.getSSLSupport();
            }
            return null;
        }

        @Override
        public void doClientAuth(SSLSupport sSLSupport) throws IOException {
            SecureNioChannel secureNioChannel = (SecureNioChannel)this.getSocket();
            SSLEngine sSLEngine = secureNioChannel.getSslEngine();
            if (!sSLEngine.getNeedClientAuth()) {
                sSLEngine.setNeedClientAuth(true);
                secureNioChannel.rehandshake(this.getEndpoint().getConnectionTimeout());
                ((JSSESupport)sSLSupport).setSession(sSLEngine.getSession());
            }
        }

        @Override
        public void setAppReadBufHandler(ApplicationBufferHandler applicationBufferHandler) {
            ((NioChannel)this.getSocket()).setAppReadBufHandler(applicationBufferHandler);
        }

        @Override
        protected <A> SocketWrapperBase.OperationState<A> newOperationState(boolean bl, ByteBuffer[] byteBufferArray, int n, int n2, SocketWrapperBase.BlockingMode blockingMode, long l, TimeUnit timeUnit, A a, SocketWrapperBase.CompletionCheck completionCheck, CompletionHandler<Long, ? super A> completionHandler, Semaphore semaphore, SocketWrapperBase.VectoredIOCompletionHandler<A> vectoredIOCompletionHandler) {
            return new NioOperationState(bl, byteBufferArray, n, n2, blockingMode, l, timeUnit, a, completionCheck, completionHandler, semaphore, vectoredIOCompletionHandler);
        }

        private class NioOperationState<A>
        extends SocketWrapperBase.OperationState<A> {
            private volatile boolean inline;

            private NioOperationState(boolean bl, ByteBuffer[] byteBufferArray, int n, int n2, SocketWrapperBase.BlockingMode blockingMode, long l, TimeUnit timeUnit, A a, SocketWrapperBase.CompletionCheck completionCheck, CompletionHandler<Long, ? super A> completionHandler, Semaphore semaphore, SocketWrapperBase.VectoredIOCompletionHandler<A> vectoredIOCompletionHandler) {
                super(NioSocketWrapper.this, bl, byteBufferArray, n, n2, blockingMode, l, timeUnit, a, completionCheck, completionHandler, semaphore, vectoredIOCompletionHandler);
                this.inline = true;
            }

            @Override
            protected boolean isInline() {
                return this.inline;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object;
                long l = 0L;
                if (NioSocketWrapper.this.getError() == null) {
                    try {
                        object = this;
                        synchronized (object) {
                            if (!this.completionDone) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Skip concurrent " + (this.read ? "read" : "write") + " notification"));
                                }
                                return;
                            }
                            if (this.read) {
                                if (!NioSocketWrapper.this.socketBufferHandler.isReadBufferEmpty()) {
                                    NioSocketWrapper.this.socketBufferHandler.configureReadBufferForRead();
                                    for (int i = 0; i < this.length && !NioSocketWrapper.this.socketBufferHandler.isReadBufferEmpty(); ++i) {
                                        l += (long)SocketWrapperBase.transfer(NioSocketWrapper.this.socketBufferHandler.getReadBuffer(), this.buffers[this.offset + i]);
                                    }
                                }
                                if (l == 0L) {
                                    l = ((NioChannel)NioSocketWrapper.this.getSocket()).read(this.buffers, this.offset, this.length);
                                    NioSocketWrapper.this.updateLastRead();
                                }
                            } else {
                                boolean bl = true;
                                if (!NioSocketWrapper.this.socketBufferHandler.isWriteBufferEmpty()) {
                                    NioSocketWrapper.this.socketBufferHandler.configureWriteBufferForRead();
                                    do {
                                        l = ((NioChannel)NioSocketWrapper.this.getSocket()).write(NioSocketWrapper.this.socketBufferHandler.getWriteBuffer());
                                    } while (!NioSocketWrapper.this.socketBufferHandler.isWriteBufferEmpty() && l > 0L);
                                    if (!NioSocketWrapper.this.socketBufferHandler.isWriteBufferEmpty()) {
                                        bl = false;
                                    }
                                    if (l > 0L) {
                                        l = 0L;
                                    }
                                }
                                if (bl) {
                                    long l2 = 0L;
                                    do {
                                        if ((l2 = ((NioChannel)NioSocketWrapper.this.getSocket()).write(this.buffers, this.offset, this.length)) == -1L) {
                                            l = l2;
                                            continue;
                                        }
                                        l += l2;
                                    } while (l2 > 0L);
                                    NioSocketWrapper.this.updateLastWrite();
                                }
                            }
                            if (l != 0L || !SocketWrapperBase.buffersArrayHasRemaining(this.buffers, this.offset, this.length)) {
                                this.completionDone = false;
                            }
                        }
                    }
                    catch (IOException iOException) {
                        NioSocketWrapper.this.setError(iOException);
                    }
                }
                if (l > 0L || l == 0L && !SocketWrapperBase.buffersArrayHasRemaining(this.buffers, this.offset, this.length)) {
                    this.completion.completed(l, this);
                } else if (l < 0L || NioSocketWrapper.this.getError() != null) {
                    object = NioSocketWrapper.this.getError();
                    if (object == null) {
                        object = new EOFException();
                    }
                    this.completion.failed((Throwable)object, this);
                } else {
                    this.inline = false;
                    if (this.read) {
                        NioSocketWrapper.this.registerReadInterest();
                    } else {
                        NioSocketWrapper.this.registerWriteInterest();
                    }
                }
            }
        }
    }

    public class Poller
    implements Runnable {
        private Selector selector;
        private final SynchronizedQueue<PollerEvent> events = new SynchronizedQueue();
        private volatile boolean close = false;
        private long nextExpiration = 0L;
        private AtomicLong wakeupCounter = new AtomicLong(0L);
        private volatile int keyCount = 0;

        public Poller() throws IOException {
            this.selector = Selector.open();
        }

        public int getKeyCount() {
            return this.keyCount;
        }

        public Selector getSelector() {
            return this.selector;
        }

        protected void destroy() {
            this.close = true;
            this.selector.wakeup();
        }

        private void addEvent(PollerEvent pollerEvent) {
            this.events.offer((Object)pollerEvent);
            if (this.wakeupCounter.incrementAndGet() == 0L) {
                this.selector.wakeup();
            }
        }

        public void add(NioChannel nioChannel, int n) {
            PollerEvent pollerEvent = (PollerEvent)NioEndpoint.this.eventCache.pop();
            if (pollerEvent == null) {
                pollerEvent = new PollerEvent(nioChannel, null, n);
            } else {
                pollerEvent.reset(nioChannel, null, n);
            }
            this.addEvent(pollerEvent);
            if (this.close) {
                NioSocketWrapper nioSocketWrapper = (NioSocketWrapper)nioChannel.getAttachment();
                NioEndpoint.this.processSocket(nioSocketWrapper, SocketEvent.STOP, false);
            }
        }

        public boolean events() {
            boolean bl = false;
            PollerEvent pollerEvent = null;
            int n = this.events.size();
            for (int i = 0; i < n && (pollerEvent = (PollerEvent)this.events.poll()) != null; ++i) {
                bl = true;
                try {
                    pollerEvent.run();
                    pollerEvent.reset();
                    if (!NioEndpoint.this.running || NioEndpoint.this.paused) continue;
                    NioEndpoint.this.eventCache.push((Object)pollerEvent);
                    continue;
                }
                catch (Throwable throwable) {
                    log.error((Object)"", throwable);
                }
            }
            return bl;
        }

        public void register(NioChannel nioChannel) {
            nioChannel.setPoller(this);
            NioSocketWrapper nioSocketWrapper = new NioSocketWrapper(nioChannel, NioEndpoint.this);
            nioChannel.setSocketWrapper(nioSocketWrapper);
            nioSocketWrapper.setPoller(this);
            nioSocketWrapper.setReadTimeout(NioEndpoint.this.getSocketProperties().getSoTimeout());
            nioSocketWrapper.setWriteTimeout(NioEndpoint.this.getSocketProperties().getSoTimeout());
            nioSocketWrapper.setKeepAliveLeft(NioEndpoint.this.getMaxKeepAliveRequests());
            nioSocketWrapper.setReadTimeout(NioEndpoint.this.getConnectionTimeout());
            nioSocketWrapper.setWriteTimeout(NioEndpoint.this.getConnectionTimeout());
            PollerEvent pollerEvent = (PollerEvent)NioEndpoint.this.eventCache.pop();
            nioSocketWrapper.interestOps(1);
            if (pollerEvent == null) {
                pollerEvent = new PollerEvent(nioChannel, nioSocketWrapper, 256);
            } else {
                pollerEvent.reset(nioChannel, nioSocketWrapper, 256);
            }
            this.addEvent(pollerEvent);
        }

        public NioSocketWrapper cancelledKey(SelectionKey selectionKey) {
            NioSocketWrapper nioSocketWrapper;
            block17: {
                nioSocketWrapper = null;
                try {
                    block16: {
                        block15: {
                            if (selectionKey == null) {
                                return null;
                            }
                            nioSocketWrapper = (NioSocketWrapper)selectionKey.attach(null);
                            if (nioSocketWrapper != null) {
                                NioEndpoint.this.getHandler().release(nioSocketWrapper);
                            }
                            if (selectionKey.isValid()) {
                                selectionKey.cancel();
                            }
                            if (nioSocketWrapper != null) {
                                try {
                                    ((NioChannel)nioSocketWrapper.getSocket()).close(true);
                                }
                                catch (Exception exception) {
                                    if (!log.isDebugEnabled()) break block15;
                                    log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.socketCloseFail"), (Throwable)exception);
                                }
                            }
                        }
                        if (selectionKey.channel().isOpen()) {
                            try {
                                selectionKey.channel().close();
                            }
                            catch (Exception exception) {
                                if (!log.isDebugEnabled()) break block16;
                                log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.channelCloseFail"), (Throwable)exception);
                            }
                        }
                    }
                    try {
                        if (nioSocketWrapper != null && nioSocketWrapper.getSendfileData() != null && nioSocketWrapper.getSendfileData().fchannel != null && nioSocketWrapper.getSendfileData().fchannel.isOpen()) {
                            nioSocketWrapper.getSendfileData().fchannel.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (nioSocketWrapper != null) {
                        NioEndpoint.this.countDownConnection();
                        nioSocketWrapper.closed = true;
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    if (!log.isDebugEnabled()) break block17;
                    log.error((Object)"", throwable);
                }
            }
            return nioSocketWrapper;
        }

        @Override
        public void run() {
            while (true) {
                Iterator<SelectionKey> iterator;
                boolean bl = false;
                try {
                    if (!this.close) {
                        bl = this.events();
                        this.keyCount = this.wakeupCounter.getAndSet(-1L) > 0L ? this.selector.selectNow() : this.selector.select(NioEndpoint.this.selectorTimeout);
                        this.wakeupCounter.set(0L);
                    }
                    if (this.close) {
                        this.events();
                        this.timeout(0, false);
                        try {
                            this.selector.close();
                        }
                        catch (IOException iOException) {
                            log.error((Object)AbstractEndpoint.sm.getString("endpoint.nio.selectorCloseFail"), (Throwable)iOException);
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    log.error((Object)"", throwable);
                    continue;
                }
                if (this.keyCount == 0) {
                    bl |= this.events();
                }
                Iterator<SelectionKey> iterator2 = iterator = this.keyCount > 0 ? this.selector.selectedKeys().iterator() : null;
                while (iterator != null && iterator.hasNext()) {
                    SelectionKey selectionKey = iterator.next();
                    iterator.remove();
                    NioSocketWrapper nioSocketWrapper = (NioSocketWrapper)selectionKey.attachment();
                    if (nioSocketWrapper == null) continue;
                    this.processKey(selectionKey, nioSocketWrapper);
                }
                this.timeout(this.keyCount, bl);
            }
            NioEndpoint.this.getStopLatch().countDown();
        }

        protected void processKey(SelectionKey selectionKey, NioSocketWrapper nioSocketWrapper) {
            try {
                if (this.close) {
                    this.cancelledKey(selectionKey);
                } else if (selectionKey.isValid() && nioSocketWrapper != null) {
                    if (selectionKey.isReadable() || selectionKey.isWritable()) {
                        if (nioSocketWrapper.getSendfileData() != null) {
                            this.processSendfile(selectionKey, nioSocketWrapper, false);
                        } else {
                            this.unreg(selectionKey, nioSocketWrapper, selectionKey.readyOps());
                            boolean bl = false;
                            if (selectionKey.isReadable() && !NioEndpoint.this.processSocket(nioSocketWrapper, SocketEvent.OPEN_READ, true)) {
                                bl = true;
                            }
                            if (!bl && selectionKey.isWritable() && !NioEndpoint.this.processSocket(nioSocketWrapper, SocketEvent.OPEN_WRITE, true)) {
                                bl = true;
                            }
                            if (bl) {
                                this.cancelledKey(selectionKey);
                            }
                        }
                    }
                } else {
                    this.cancelledKey(selectionKey);
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                this.cancelledKey(selectionKey);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.error((Object)"", throwable);
            }
        }

        public SendfileState processSendfile(SelectionKey selectionKey, NioSocketWrapper nioSocketWrapper, boolean bl) {
            NioChannel nioChannel = null;
            try {
                Object object;
                this.unreg(selectionKey, nioSocketWrapper, selectionKey.readyOps());
                SendfileData sendfileData = nioSocketWrapper.getSendfileData();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Processing send file for: " + sendfileData.fileName));
                }
                if (sendfileData.fchannel == null) {
                    object = new File(sendfileData.fileName);
                    FileInputStream fileInputStream = new FileInputStream((File)object);
                    sendfileData.fchannel = fileInputStream.getChannel();
                }
                Object object2 = object = (nioChannel = (NioChannel)nioSocketWrapper.getSocket()) instanceof SecureNioChannel ? nioChannel : nioChannel.getIOChannel();
                if (nioChannel.getOutboundRemaining() > 0) {
                    if (nioChannel.flushOutbound()) {
                        nioSocketWrapper.updateLastWrite();
                    }
                } else {
                    long l = sendfileData.fchannel.transferTo(sendfileData.pos, sendfileData.length, (WritableByteChannel)object);
                    if (l > 0L) {
                        sendfileData.pos += l;
                        sendfileData.length -= l;
                        nioSocketWrapper.updateLastWrite();
                    } else if (sendfileData.fchannel.size() <= sendfileData.pos) {
                        throw new IOException("Sendfile configured to send more data than was available");
                    }
                }
                if (sendfileData.length <= 0L && nioChannel.getOutboundRemaining() <= 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Send file complete for: " + sendfileData.fileName));
                    }
                    nioSocketWrapper.setSendfileData(null);
                    try {
                        sendfileData.fchannel.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!bl) {
                        switch (sendfileData.keepAliveState) {
                            case NONE: {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"Send file connection is being closed");
                                }
                                NioEndpoint.this.close(nioChannel, selectionKey);
                                break;
                            }
                            case PIPELINED: {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"Connection is keep alive, processing pipe-lined data");
                                }
                                if (NioEndpoint.this.processSocket(nioSocketWrapper, SocketEvent.OPEN_READ, true)) break;
                                NioEndpoint.this.close(nioChannel, selectionKey);
                                break;
                            }
                            case OPEN: {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"Connection is keep alive, registering back for OP_READ");
                                }
                                this.reg(selectionKey, nioSocketWrapper, 1);
                            }
                        }
                    }
                    return SendfileState.DONE;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("OP_WRITE for sendfile: " + sendfileData.fileName));
                }
                if (bl) {
                    this.add((NioChannel)nioSocketWrapper.getSocket(), 4);
                } else {
                    this.reg(selectionKey, nioSocketWrapper, 4);
                }
                return SendfileState.PENDING;
            }
            catch (IOException iOException) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Unable to complete sendfile request:", (Throwable)iOException);
                }
                if (!bl && nioChannel != null) {
                    NioEndpoint.this.close(nioChannel, selectionKey);
                }
                return SendfileState.ERROR;
            }
            catch (Throwable throwable) {
                log.error((Object)"", throwable);
                if (!bl && nioChannel != null) {
                    NioEndpoint.this.close(nioChannel, selectionKey);
                }
                return SendfileState.ERROR;
            }
        }

        protected void unreg(SelectionKey selectionKey, NioSocketWrapper nioSocketWrapper, int n) {
            this.reg(selectionKey, nioSocketWrapper, selectionKey.interestOps() & ~n);
        }

        protected void reg(SelectionKey selectionKey, NioSocketWrapper nioSocketWrapper, int n) {
            selectionKey.interestOps(n);
            nioSocketWrapper.interestOps(n);
        }

        protected void timeout(int n, boolean bl) {
            long l = System.currentTimeMillis();
            if (this.nextExpiration > 0L && (n > 0 || bl) && l < this.nextExpiration && !this.close) {
                return;
            }
            int n2 = 0;
            try {
                for (SelectionKey selectionKey : this.selector.keys()) {
                    ++n2;
                    try {
                        long l2;
                        long l3;
                        NioSocketWrapper nioSocketWrapper = (NioSocketWrapper)selectionKey.attachment();
                        if (nioSocketWrapper == null) {
                            this.cancelledKey(selectionKey);
                            continue;
                        }
                        if (this.close) {
                            selectionKey.interestOps(0);
                            nioSocketWrapper.interestOps(0);
                            this.processKey(selectionKey, nioSocketWrapper);
                            continue;
                        }
                        if ((nioSocketWrapper.interestOps() & 1) != 1 && (nioSocketWrapper.interestOps() & 4) != 4) continue;
                        boolean bl2 = false;
                        if ((nioSocketWrapper.interestOps() & 1) == 1) {
                            l3 = l - nioSocketWrapper.getLastRead();
                            l2 = nioSocketWrapper.getReadTimeout();
                            boolean bl3 = bl2 = l2 > 0L && l3 > l2;
                        }
                        if (!bl2 && (nioSocketWrapper.interestOps() & 4) == 4) {
                            l3 = l - nioSocketWrapper.getLastWrite();
                            l2 = nioSocketWrapper.getWriteTimeout();
                            boolean bl4 = bl2 = l2 > 0L && l3 > l2;
                        }
                        if (!bl2) continue;
                        selectionKey.interestOps(0);
                        nioSocketWrapper.interestOps(0);
                        nioSocketWrapper.setError(new SocketTimeoutException());
                        if (NioEndpoint.this.processSocket(nioSocketWrapper, SocketEvent.ERROR, true)) continue;
                        this.cancelledKey(selectionKey);
                    }
                    catch (CancelledKeyException cancelledKeyException) {
                        this.cancelledKey(selectionKey);
                    }
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                log.warn((Object)AbstractEndpoint.sm.getString("endpoint.nio.timeoutCme"), (Throwable)concurrentModificationException);
            }
            long l4 = this.nextExpiration;
            this.nextExpiration = System.currentTimeMillis() + NioEndpoint.this.socketProperties.getTimeoutInterval();
            if (log.isTraceEnabled()) {
                log.trace((Object)("timeout completed: keys processed=" + n2 + "; now=" + l + "; nextExpiration=" + l4 + "; keyCount=" + n + "; hasEvents=" + bl + "; eval=" + (l < l4 && (n > 0 || bl) && !this.close)));
            }
        }
    }

    public static class PollerEvent
    implements Runnable {
        private NioChannel socket;
        private int interestOps;
        private NioSocketWrapper socketWrapper;

        public PollerEvent(NioChannel nioChannel, NioSocketWrapper nioSocketWrapper, int n) {
            this.reset(nioChannel, nioSocketWrapper, n);
        }

        public void reset(NioChannel nioChannel, NioSocketWrapper nioSocketWrapper, int n) {
            this.socket = nioChannel;
            this.interestOps = n;
            this.socketWrapper = nioSocketWrapper;
        }

        public void reset() {
            this.reset(null, null, 0);
        }

        @Override
        public void run() {
            if (this.interestOps == 256) {
                try {
                    this.socket.getIOChannel().register(this.socket.getPoller().getSelector(), 1, this.socketWrapper);
                }
                catch (Exception exception) {
                    log.error((Object)AbstractEndpoint.sm.getString("endpoint.nio.registerFail"), (Throwable)exception);
                }
            } else {
                SelectionKey selectionKey = this.socket.getIOChannel().keyFor(this.socket.getPoller().getSelector());
                try {
                    if (selectionKey == null) {
                        this.socket.socketWrapper.getEndpoint().countDownConnection();
                        ((NioSocketWrapper)this.socket.socketWrapper).closed = true;
                    } else {
                        NioSocketWrapper nioSocketWrapper = (NioSocketWrapper)selectionKey.attachment();
                        if (nioSocketWrapper != null) {
                            int n = selectionKey.interestOps() | this.interestOps;
                            nioSocketWrapper.interestOps(n);
                            selectionKey.interestOps(n);
                        } else {
                            this.socket.getPoller().cancelledKey(selectionKey);
                        }
                    }
                }
                catch (CancelledKeyException cancelledKeyException) {
                    try {
                        this.socket.getPoller().cancelledKey(selectionKey);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public String toString() {
            return "Poller event: socket [" + this.socket + "], socketWrapper [" + this.socketWrapper + "], interestOps [" + this.interestOps + "]";
        }
    }

    protected class Acceptor
    extends AbstractEndpoint.Acceptor {
        protected Acceptor() {
        }

        @Override
        public void run() {
            int n = 0;
            long l = 0L;
            while (NioEndpoint.this.running) {
                while (NioEndpoint.this.paused && NioEndpoint.this.running) {
                    if (this.state != AbstractEndpoint.Acceptor.AcceptorState.PAUSED) {
                        l = System.nanoTime();
                        this.state = AbstractEndpoint.Acceptor.AcceptorState.PAUSED;
                    }
                    if (System.nanoTime() - l <= 1000000L) continue;
                    try {
                        if (System.nanoTime() - l > 10000000L) {
                            Thread.sleep(10L);
                            continue;
                        }
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!NioEndpoint.this.running) break;
                this.state = AbstractEndpoint.Acceptor.AcceptorState.RUNNING;
                try {
                    NioEndpoint.this.countUpOrAwaitConnection();
                    SocketChannel socketChannel = null;
                    try {
                        socketChannel = NioEndpoint.this.serverSock.accept();
                    }
                    catch (IOException iOException) {
                        NioEndpoint.this.countDownConnection();
                        if (!NioEndpoint.this.running) break;
                        n = NioEndpoint.this.handleExceptionWithDelay(n);
                        throw iOException;
                    }
                    n = 0;
                    if (NioEndpoint.this.running && !NioEndpoint.this.paused) {
                        if (NioEndpoint.this.setSocketOptions(socketChannel)) continue;
                        this.closeSocket(socketChannel);
                        continue;
                    }
                    this.closeSocket(socketChannel);
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    log.error((Object)AbstractEndpoint.sm.getString("endpoint.accept.fail"), throwable);
                }
            }
            this.state = AbstractEndpoint.Acceptor.AcceptorState.ENDED;
        }

        private void closeSocket(SocketChannel socketChannel) {
            block5: {
                block4: {
                    NioEndpoint.this.countDownConnection();
                    try {
                        socketChannel.socket().close();
                    }
                    catch (IOException iOException) {
                        if (!log.isDebugEnabled()) break block4;
                        log.debug((Object)AbstractEndpoint.sm.getString("endpoint.err.close"), (Throwable)iOException);
                    }
                }
                try {
                    socketChannel.close();
                }
                catch (IOException iOException) {
                    if (!log.isDebugEnabled()) break block5;
                    log.debug((Object)AbstractEndpoint.sm.getString("endpoint.err.close"), (Throwable)iOException);
                }
            }
        }
    }
}

