/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.client;

import java.util.regex.Pattern;
import org.graalvm.visualvm.lib.jfluid.global.CommonConstants;
import org.graalvm.visualvm.lib.jfluid.utils.formatting.DefaultMethodNameFormatter;
import org.graalvm.visualvm.lib.jfluid.utils.formatting.MethodNameFormatter;

public class ClientUtils
implements CommonConstants {
    private static final MethodNameFormatter classNameFormatter = new DefaultMethodNameFormatter(1);
    public static final String LINES_PREFIX = "[lines]";

    public static String selectionToString(SourceCodeSelection selection) {
        if (selection == null) {
            return "";
        }
        if (selection.definedViaSourceLines()) {
            return LINES_PREFIX + selection.getClassName() + "," + selection.getStartLine() + "," + selection.getEndLine();
        }
        if (selection.getMethodName() == null) {
            return selection.getClassName();
        }
        if (selection.getMethodSignature() == null) {
            return selection.getClassName() + "," + selection.getMethodName();
        }
        return selection.getClassName() + "," + selection.getMethodName() + "," + selection.getMethodSignature();
    }

    public static SourceCodeSelection stringToSelection(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        boolean viaLines = false;
        if (str.startsWith(LINES_PREFIX)) {
            viaLines = true;
            str = str.substring(LINES_PREFIX.length());
        }
        String[] parts = str.split(",");
        if (viaLines) {
            if (parts.length != 3) {
                return null;
            }
            try {
                return new SourceCodeSelection(parts[0], Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        String className = "";
        if (parts.length > 0) {
            className = parts[0];
        }
        String methodName = "";
        if (parts.length > 1) {
            methodName = parts[1];
        }
        String methodSig = "";
        if (parts.length > 2) {
            methodSig = parts[2];
        }
        return new SourceCodeSelection(className, methodName, methodSig);
    }

    public static String formatClassName(String className) {
        return classNameFormatter.formatMethodName(className, "", "").toFormatted();
    }

    public static String parseClassName(String text, boolean allowWildcards) {
        if (text.isEmpty()) {
            return null;
        }
        if (text.equals(".*")) {
            return allowWildcards ? "" : null;
        }
        if (text.equals(".**")) {
            return null;
        }
        String[] components = text.split("\\.", -1);
        int len = components.length;
        String last = components[len - 1];
        if (len == 1) {
            if (text.startsWith("*")) {
                return null;
            }
            return ClientUtils.checkWildcards(text, allowWildcards, false) ? text : null;
        }
        for (int i = 0; i < len; ++i) {
            if (components[i].isEmpty()) {
                return null;
            }
            if (i >= len - 1 || !components[i].contains("*")) continue;
            return null;
        }
        if (ClientUtils.checkWildcards(last, allowWildcards, true)) {
            return text;
        }
        return null;
    }

    private static boolean checkWildcards(String last, boolean allowWildcards, boolean allowSubPackages) {
        int wildcard = last.indexOf(42);
        if (wildcard == -1) {
            return true;
        }
        if (!allowWildcards) {
            return false;
        }
        if (wildcard == last.length() - 1) {
            return true;
        }
        if (!allowSubPackages) {
            return false;
        }
        if (wildcard != last.length() - 2 || !last.endsWith("*")) {
            return false;
        }
        return wildcard == 0 || last.charAt(wildcard - 1) == '$';
    }

    public static class TargetAppOrVMTerminated
    extends Exception {
        public static final int VM = 1;
        public static final int APP = 2;
        int code;

        public TargetAppOrVMTerminated(int code) {
            this.code = code;
        }

        public TargetAppOrVMTerminated(int code, String message) {
            super(message);
            this.code = code;
        }

        public boolean isAppTerminated() {
            return this.code == 2;
        }

        @Override
        public String getMessage() {
            if (super.getMessage() == null) {
                return this.code == 1 ? "Target JVM inactive" : "Target application inactive";
            }
            return super.getMessage();
        }

        public boolean isVMTerminated() {
            return this.code == 1;
        }
    }

    public static class TargetAppFailedToStart
    extends Exception {
        private String origCause;

        public TargetAppFailedToStart(String errorMessage) {
            this.origCause = errorMessage;
        }

        public String getOrigCause() {
            return this.origCause;
        }
    }

    public static class SourceCodeSelection
    implements Cloneable {
        private static final Pattern P1 = Pattern.compile("$**", 16);
        private static final Pattern P2 = Pattern.compile(".**", 16);
        private static final Pattern P3 = Pattern.compile(".*", 16);
        String className;
        String normalizedClassName;
        String methodName;
        String methodSignature;
        boolean isMarkerMethod;
        int endLine;
        int startLine;

        public SourceCodeSelection(String className, int startLine, int endLine) {
            this.className = className != null ? className : "";
            this.startLine = startLine;
            this.endLine = endLine;
        }

        public SourceCodeSelection(String className, String methodName, String methodSignature) {
            this.className = className != null ? className : "";
            this.methodName = methodName != null ? methodName : "";
            this.methodSignature = methodSignature != null ? methodSignature : "";
            this.endLine = -1;
            this.startLine = -1;
        }

        public SourceCodeSelection(int specialCode) {
            if (specialCode == 1) {
                this.className = "*NO_CLASS_NAME*";
                this.methodName = "*NO_METHOD_NAME*";
                this.methodSignature = "*NO_METHOD_SIGNATURE*";
                this.endLine = 0;
                this.startLine = 0;
            }
        }

        public String getClassName() {
            return this.className;
        }

        String getNormalizedClassName() {
            if (this.normalizedClassName == null) {
                this.normalizedClassName = P1.matcher(this.className).replaceAll("");
                this.normalizedClassName = P2.matcher(this.normalizedClassName).replaceAll("");
                this.normalizedClassName = P3.matcher(this.normalizedClassName).replaceAll("");
            }
            return this.normalizedClassName;
        }

        public int getEndLine() {
            return this.endLine;
        }

        public void setMarkerMethod(boolean value) {
            this.isMarkerMethod = value;
        }

        public boolean isMarkerMethod() {
            return this.isMarkerMethod;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getMethodSignature() {
            return this.methodSignature;
        }

        public int getStartLine() {
            return this.startLine;
        }

        public boolean isDefaultPackage() {
            return this.className.isEmpty() && this.methodName.isEmpty() && this.methodSignature.isEmpty();
        }

        public boolean isInDefaultPackage() {
            return this.isDefaultPackage() || !this.className.contains(".");
        }

        public Object clone() throws CloneNotSupportedException {
            SourceCodeSelection clone = (SourceCodeSelection)super.clone();
            clone.className = this.className;
            clone.normalizedClassName = this.normalizedClassName;
            clone.methodName = this.methodName;
            clone.methodSignature = this.methodSignature;
            clone.endLine = this.endLine;
            clone.startLine = this.startLine;
            return clone;
        }

        public boolean contains(SourceCodeSelection anotherSelection) {
            if (this.definedViaSourceLines()) {
                if (this.className.equals(anotherSelection.className)) {
                    return this.startLine >= anotherSelection.startLine && this.endLine <= anotherSelection.endLine;
                }
            } else {
                if (this.isDefaultPackage()) {
                    return this.isInDefaultPackage();
                }
                String thisFlattened = this.toFlattened().replace('.', '\\').replace('$', '\\') + "\\";
                String anotherFlattened = anotherSelection.toFlattened().replace('.', '\\').replace('$', '\\');
                return anotherFlattened.startsWith(thisFlattened);
            }
            return false;
        }

        public boolean definedViaMethodName() {
            return this.startLine == -1;
        }

        public boolean definedViaSourceLines() {
            return this.startLine > 0;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SourceCodeSelection)) {
                return false;
            }
            SourceCodeSelection other = (SourceCodeSelection)obj;
            if (this.startLine != other.startLine || this.endLine != other.endLine) {
                return false;
            }
            if (!this.getNormalizedClassName().equals(other.getNormalizedClassName())) {
                return false;
            }
            if (this.methodName != null ? !this.methodName.equals(other.methodName) : other.methodName != null) {
                return false;
            }
            return !(this.methodSignature != null ? !this.methodSignature.equals(other.methodSignature) : other.methodSignature != null);
        }

        public int hashCode() {
            int hashcode = 0;
            hashcode += this.startLine + this.endLine;
            hashcode += this.className.hashCode();
            hashcode += this.methodName != null ? this.methodName.hashCode() : 0;
            return hashcode += this.methodSignature != null ? this.methodSignature.hashCode() : 0;
        }

        public String toFlattened() {
            if (this.className == null || this.className.length() == 0) {
                return "";
            }
            boolean wildcard = this.className.endsWith("*");
            StringBuilder flattenedBuf = new StringBuilder(this.getNormalizedClassName());
            if (!wildcard && this.methodName != null && this.methodName.length() > 0 && !this.methodName.endsWith("*")) {
                flattenedBuf.append('.').append(this.methodName);
            }
            if (!wildcard && this.methodSignature != null && this.methodSignature.length() > 0 && !this.methodSignature.endsWith("*")) {
                flattenedBuf.append(this.methodSignature);
            }
            return flattenedBuf.toString();
        }

        public String toString() {
            if (this.definedViaSourceLines()) {
                return "Source Code defined via lines: [class: " + this.className + ", start line: " + this.startLine + ", end line: " + this.endLine + "]";
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Source Code defined via method: ");
            sb.append("\n");
            sb.append("  class: ");
            sb.append(this.className);
            sb.append("\n  ");
            if (this.methodName != null) {
                sb.append("  method: ");
                sb.append(this.methodName);
                sb.append("  ");
                sb.append(this.methodSignature);
                sb.append("\n  ");
            }
            if (this.isMarkerMethod) {
                sb.append("[Marker Method]\n");
            }
            return sb.toString();
        }
    }
}

