/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.visualvm.lib.jfluid.heap.GCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.HprofGCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.HprofHeap;
import org.graalvm.visualvm.lib.jfluid.heap.JavaFrameHprofGCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.JniLocalHprofGCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.LongHashMap;
import org.graalvm.visualvm.lib.jfluid.heap.TagBounds;
import org.graalvm.visualvm.lib.jfluid.heap.ThreadObjectGCRoot;
import org.graalvm.visualvm.lib.jfluid.heap.ThreadObjectHprofGCRoot;

class HprofGCRoots {
    final HprofHeap heap;
    private final Object threadSerialMapLock = new Object();
    private LongHashMap threadSerialMap;
    private int rootThreadsCount;
    private Map gcRoots;
    private final Object gcRootLock = new Object();
    private List<GCRoot> gcRootsList;

    HprofGCRoots(HprofHeap h) {
        this.heap = h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<GCRoot> getGCRoots() {
        Object object = this.gcRootLock;
        synchronized (object) {
            if (this.gcRoots == null) {
                this.gcRoots = new HashMap(16384);
                this.gcRootsList = new ArrayList<GCRoot>(16384);
                this.computeGCRootsFor(this.heap.getHeapTagBound(255));
                this.computeGCRootsFor(this.heap.getHeapTagBound(1));
                this.computeGCRootsFor(this.heap.getHeapTagBound(2));
                this.computeGCRootsFor(this.heap.getHeapTagBound(3));
                this.computeGCRootsFor(this.heap.getHeapTagBound(4));
                this.computeGCRootsFor(this.heap.getHeapTagBound(5));
                this.computeGCRootsFor(this.heap.getHeapTagBound(6));
                this.computeGCRootsFor(this.heap.getHeapTagBound(7));
                this.computeGCRootsFor(this.heap.getHeapTagBound(8));
                this.computeGCRootsFor(this.heap.getHeapTagBound(137));
                this.computeGCRootsFor(this.heap.getHeapTagBound(138));
                this.computeGCRootsFor(this.heap.getHeapTagBound(139));
                this.computeGCRootsFor(this.heap.getHeapTagBound(140));
                this.computeGCRootsFor(this.heap.getHeapTagBound(141));
                this.computeGCRootsFor(this.heap.getHeapTagBound(142));
                this.gcRootsList = Collections.unmodifiableList(this.gcRootsList);
            }
            return this.gcRootsList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getGCRoots(Long instanceId) {
        Object object = this.gcRootLock;
        synchronized (object) {
            if (this.gcRoots == null) {
                this.heap.getGCRoots();
            }
            return this.gcRoots.get(instanceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThreadObjectGCRoot getThreadGCRoot(int threadSerialNumber) {
        List<GCRoot> roots = this.getGCRoots();
        Object object = this.threadSerialMapLock;
        synchronized (object) {
            int threadIndex;
            if (this.threadSerialMap == null) {
                this.threadSerialMap = new LongHashMap(this.rootThreadsCount);
                for (int i = 0; i < roots.size(); ++i) {
                    GCRoot gcRoot = roots.get(i);
                    if (!(gcRoot instanceof ThreadObjectHprofGCRoot)) continue;
                    ThreadObjectHprofGCRoot threadObjGC = (ThreadObjectHprofGCRoot)gcRoot;
                    this.threadSerialMap.put(threadObjGC.getThreadSerialNumber(), i);
                }
            }
            if ((threadIndex = (int)this.threadSerialMap.get(threadSerialNumber)) != -1) {
                return (ThreadObjectGCRoot)roots.get(threadIndex);
            }
            return null;
        }
    }

    private void computeGCRootsFor(TagBounds tagBounds) {
        if (tagBounds != null) {
            int rootTag = tagBounds.tag;
            long[] offset = new long[]{tagBounds.startOffset};
            while (offset[0] < tagBounds.endOffset) {
                HprofGCRoot root;
                long start = offset[0];
                if (this.heap.readDumpTag(offset) != rootTag) continue;
                if (rootTag == 8) {
                    root = new ThreadObjectHprofGCRoot(this, start);
                    ++this.rootThreadsCount;
                } else {
                    root = rootTag == 3 ? new JavaFrameHprofGCRoot(this, start) : (rootTag == 2 ? new JniLocalHprofGCRoot(this, start) : new HprofGCRoot(this, start));
                }
                Long objectId = root.getInstanceId();
                Object val = this.gcRoots.get(objectId);
                if (val == null) {
                    this.gcRoots.put(objectId, root);
                } else if (val instanceof GCRoot) {
                    ArrayList<Object> vals = new ArrayList<Object>(2);
                    vals.add(val);
                    vals.add(root);
                    this.gcRoots.put(objectId, vals);
                } else {
                    ((Collection)val).add(root);
                }
                this.gcRootsList.add(root);
            }
        }
    }
}

