/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Objects;
import org.graalvm.visualvm.application.ApplicationSupport;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.StatefulDataSource;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.datasupport.DataRemovedListener;
import org.graalvm.visualvm.core.options.GlobalPreferences;
import org.graalvm.visualvm.core.ui.DataSourceWindowListener;
import org.graalvm.visualvm.core.ui.DataSourceWindowManager;
import org.graalvm.visualvm.host.Host;

public abstract class Application
extends StatefulDataSource {
    public static final Application CURRENT_APPLICATION = ApplicationSupport.getInstance().createCurrentApplication();
    public static final int UNKNOWN_PID = -1;
    private String id;
    private Host host;

    public Application(Host host, String id) {
        this(host, id, 1);
    }

    protected Application(Host host, String id, int state) {
        super(state);
        if (host == null) {
            throw new IllegalArgumentException("Host cannot be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("Application id cannot be null");
        }
        this.host = host;
        this.id = id;
    }

    public final String getId() {
        return this.id;
    }

    public int getPid() {
        return -1;
    }

    public final Host getHost() {
        return this.host;
    }

    public final boolean isLocalApplication() {
        return Host.LOCALHOST.equals((Object)this.getHost());
    }

    protected boolean supportsFinishedRemove() {
        return true;
    }

    protected boolean handleControlledRemove() {
        if (!this.canRemoveFinished_Opened()) {
            class ApplicationListener
            implements DataSourceWindowListener<Application>,
            DataRemovedListener<Application>,
            PropertyChangeListener {
                private boolean done;

                ApplicationListener() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void windowClosed(Application application) {
                    ApplicationListener applicationListener = this;
                    synchronized (applicationListener) {
                        if (!this.done) {
                            this.unregister();
                            if (Application.this.canRemoveFinished_Snapshots()) {
                                application.getHost().getRepository().removeDataSource((DataSource)application);
                            }
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void dataRemoved(Application application) {
                    ApplicationListener applicationListener = this;
                    synchronized (applicationListener) {
                        if (!this.done) {
                            this.unregister();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("prop_state".equals(evt.getPropertyName()) && !Objects.equals(evt.getNewValue(), 0)) {
                        ApplicationListener applicationListener = this;
                        synchronized (applicationListener) {
                            if (!this.done) {
                                this.unregister();
                            }
                        }
                    }
                }

                void register() {
                    Application.this.notifyWhenRemoved(this);
                    Application.this.addPropertyChangeListener("prop_state", this);
                    DataSourceWindowManager.sharedInstance().addWindowListener((DataSource)Application.this, (DataSourceWindowListener)this);
                }

                void unregister() {
                    this.done = true;
                    DataSourceWindowManager.sharedInstance().removeWindowListener((DataSource)Application.this, (DataSourceWindowListener)this);
                    Application.this.removePropertyChangeListener(this);
                }
            }
            new ApplicationListener().register();
            return true;
        }
        return !this.canRemoveFinished_Snapshots();
    }

    private boolean canRemoveFinished_Opened() {
        return GlobalPreferences.sharedInstance().autoRemoveOpenedFinishedApps() || !DataSourceWindowManager.sharedInstance().isDataSourceOpened((DataSource)this);
    }

    private boolean canRemoveFinished_Snapshots() {
        return GlobalPreferences.sharedInstance().autoRemoveFinishedAppsWithSnapshots() || this.getRepository().getDataSources().isEmpty();
    }

    public final int hashCode() {
        return this.getId().hashCode();
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof Application)) {
            return false;
        }
        Application app = (Application)((Object)obj);
        return this.getId().equals(app.getId());
    }

    public String toString() {
        return "Application [id: " + this.getId() + ", pid: " + this.getPid() + ", host: " + this.getHost().getHostName() + "]";
    }

    protected Storage createStorage() {
        File directory = new File(Storage.getTemporaryStorageDirectoryString() + File.separator + Application.validFileName(this.getId()));
        return new Storage(directory);
    }

    private static String validFileName(String fileName) {
        char[] fileNameCh = fileName.toCharArray();
        StringBuilder validFileName = new StringBuilder();
        for (char ch : fileNameCh) {
            if (Character.isLetterOrDigit(ch)) {
                validFileName.append(ch);
                continue;
            }
            validFileName.append('_');
        }
        return validFileName.toString();
    }
}

